//***********************************************************************
//***********************************************************************
//****																*****
//**** 							Get5311Data							*****
//****																*****
//****	Positionsdaten / Magnitude und Flags (18 Bit) aus AS5311	*****
//****	auslesen													*****
//****	T=0:  --> Position											*****
//****	T=1:  --> Magnitude											*****
//****																*****
//****	Rckgabe True --> ser. Data Valid, False --> Invalid    	*****
//****																*****
//***********************************************************************
//***********************************************************************

short Get5311Data(short T)
{ int32 ReadOut=0;							// eingelesener Wert, 18 Bit
  int Pari=0;								// fr Parittstest
  short SerialDataValid=false;
  int Bitcount;					
  short PariBit;

  #bit ReadOut_D0=ReadOut.0	
  #bit ReadOut_OCF=ReadOut.4
  #bit ReadOut_COF=ReadOut.3
  #bit ReadOut_LIN=ReadOut.2
  #Bit ReadOut_MagInc=ReadOut.1
  #bit ReadOut_MagDec=ReadOut.0
  #bit Pari_D0=Pari.0						

  if(T==0) SCLK=1; else SCLK=0;				// Position oder Magnitude
  CSN=0;									// Start Datentransfer
  DoNop;									// sicherstellen, dass Daten anliegen (500ns bis fallende Flanke)
  if(T==0) { SCLK=0; DoNop;}
  SCLK=1; DoNop;

  for(Bitcount=0; Bitcount<17; ++Bitcount)
  { SCLK=0;
	ReadOut<<=1;
	if(SDI)									// Datenbit einlesen
	{ ReadOut_D0=1; Pari++;}	
	else
	{ ReadOut_D0=0; }	
	SCLK=1;
  }
  PariBit=SDI;
  CSN=1;

  if(Pari_D0==PariBit)						// Parittsvergleich
    SerialDataValid=true;

  // Flags fr Result und globale Verwendung setzen
  As5311Flags=0;
  Flag_SDOK=SerialDataValid;
  Flag_OCF=ReadOut_OCF; 
  Flag_COF=ReadOut_COF;
  Flag_LIN=ReadOut_LIN;
  Flag_MagInc=ReadOut_MagInc;
  Flag_MagDec=ReadOut_MagDec;

  ReadOut>>=5;								// aktuelle Position / Magnitude
  if(T==1) ReadOut>>=4;
  AS5311Value=ReadOut;

  return(SerialDataValid);

}

